/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.lucene;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

class DlsGetEvaluator {
    private final Bits liveBits;
    private final int numDocs;
    private final IndexReader.CacheHelper readerCacheHelper;
    private final boolean hasDeletions;
    private static final Logger log = LogManager.getLogger(DlsGetEvaluator.class);

    public DlsGetEvaluator(FilterLeafReader filterLeafReader, Query dlsQuery, LeafReader in, boolean applyDlsHere) {
        try {
            log.trace("Creating DlsGetEvaluator\ndlsQuery: {}\napplyDlsHere: {}", (Object)dlsQuery, (Object)applyDlsHere);
            if (dlsQuery != null && applyDlsHere) {
                IndexSearcher searcher = new IndexSearcher((IndexReader)filterLeafReader);
                searcher.setQueryCache(null);
                Weight preserveWeight = searcher.createWeight(dlsQuery, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                int maxDoc = in.maxDoc();
                FixedBitSet bits = new FixedBitSet(maxDoc);
                Scorer preserveScorer = preserveWeight.scorer(filterLeafReader.getContext());
                if (preserveScorer != null) {
                    bits.or(preserveScorer.iterator());
                }
                if (in.hasDeletions()) {
                    Bits oldLiveDocs = in.getLiveDocs();
                    assert (oldLiveDocs != null);
                    BitSetIterator it = new BitSetIterator((BitSet)bits, 0L);
                    int i = it.nextDoc();
                    while (i != Integer.MAX_VALUE) {
                        if (!oldLiveDocs.get(i)) {
                            bits.clear(i);
                        }
                        i = it.nextDoc();
                    }
                }
                this.liveBits = bits;
                this.numDocs = in.numDocs();
                this.readerCacheHelper = null;
                this.hasDeletions = true;
            } else {
                this.liveBits = in.getLiveDocs();
                this.numDocs = in.numDocs();
                this.readerCacheHelper = in.getReaderCacheHelper();
                this.hasDeletions = in.hasDeletions();
            }
        }
        catch (IOException e) {
            log.error("IOException in DlsGetEvaluator", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Bits getLiveDocs() {
        return this.liveBits;
    }

    public int numDocs() {
        return this.numDocs;
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.readerCacheHelper;
    }

    public boolean hasDeletions() {
        return this.hasDeletions;
    }
}

